//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Threading;

namespace Benchmark
{
	/// <summary>
	/// Podsumowanie dla WorkComplete.
	/// </summary>
	class WorkComplete
	{
		private int count;
		private ManualResetEvent _lock;
		// Ustawienie pocztkowego licznika
		public WorkComplete(int count) 
		{
			this.count = count;
			_lock = new ManualResetEvent(false);
		}

		public void Reset(int count)
		{
			lock(this)
			{
				this.count = count;
				_lock.Reset();
			}
		}
		public void P() 
		{
			Monitor.Enter(this);
			if(count > 0) 
			{
				Monitor.Exit(this);
				_lock.WaitOne();
				return;
			}
			Monitor.Exit(this);
		}

		public void V() 
		{
			// Zablokowanie obiektu
			// Zwikszenie o jedn jednostk semafora
			lock(this)
			{
				count--;
				if(count == 0)
				{
					// Sygnalizacja kolejnego oczekujcego wtku
					_lock.Set();
				}
			}
		}
	}
}
